import Vapor

struct WebhookController: RouteCollection {
    func boot(routes: RoutesBuilder) throws {
        let webhooksRoute = routes.grouped("webhook")
        webhooksRoute.post(use: webhookReceived)
    }
    
    func webhookReceived(_ req: Request) throws -> EventLoopFuture<String> {
        do {
            let webhookData = try req.content.decode(WebhookData.self)
            
            if webhookData.status == "SUCCESS" {
                // Process the data here as needed
                // For example, log it or perform other actions
                return req.eventLoop.future("Webhook received successfully")
            } else {
                return req.eventLoop.future(error: Abort(.badRequest, reason: "Invalid status: \(webhookData.status)"))
            }
        } catch {
            return req.eventLoop.future(error: error)
        }
    }
}

struct WebhookData: Content {
    let status: String
    let order_id: String
    let remark1: String
}

let app = Application()
defer { app.shutdown() }
app.http.server.configuration.port = 8080

try app.routes.register(collection: WebhookController())

try app.run()
