// Method to check the order status
public async Task<dynamic> CheckOrderStatusAsync(string userToken, string orderId)
{
    using (var client = new HttpClient())
    {
        var parameters = new Dictionary<string, string>
        {
            {"user_token", userToken},
            {"order_id", orderId}
        };

        var content = new FormUrlEncodedContent(parameters);
        var response = await client.PostAsync(_apiBaseUrl + "check-order-status", content);
        var responseString = await response.Content.ReadAsStringAsync();

        return JsonConvert.DeserializeObject<dynamic>(responseString);
    }
}
